import React from 'react';
import type { BaseButtonProps, LegacyButtonType } from './button';
export declare const isTwoCNChar: (string: string) => boolean;
export declare function convertLegacyProps(type?: LegacyButtonType): Pick<BaseButtonProps, 'danger' | 'type'>;
export declare function isString(str: any): str is string;
export declare function isUnBorderedButtonType(type?: ButtonType): type is "text" | "link";
export declare function spaceChildren(children: React.ReactNode, needInserted: boolean): (number | React.JSX.Element)[] | null | undefined;
declare const ButtonTypes: readonly ["default", "primary", "dashed", "link", "text"];
export type ButtonType = (typeof ButtonTypes)[number];
declare const ButtonShapes: readonly ["default", "circle", "round"];
export type ButtonShape = (typeof ButtonShapes)[number];
declare const ButtonHTMLTypes: readonly ["submit", "button", "reset"];
export type ButtonHTMLType = (typeof ButtonHTMLTypes)[number];
export {};
