import type * as React from 'react';
import type { ClosableType } from '../_util/hooks/useClosable';
interface DivProps extends React.HTMLProps<HTMLDivElement> {
    'data-testid'?: string;
}
export declare const NotificationPlacements: readonly ["top", "topLeft", "topRight", "bottom", "bottomLeft", "bottomRight"];
export type NotificationPlacement = (typeof NotificationPlacements)[number];
export type IconType = 'success' | 'info' | 'error' | 'warning';
export interface ArgsProps {
    message: React.ReactNode;
    description?: React.ReactNode;
    btn?: React.ReactNode;
    key?: React.Key;
    onClose?: () => void;
    duration?: number | null;
    showProgress?: boolean;
    pauseOnHover?: boolean;
    icon?: React.ReactNode;
    placement?: NotificationPlacement;
    style?: React.CSSProperties;
    className?: string;
    readonly type?: IconType;
    onClick?: () => void;
    closeIcon?: React.ReactNode;
    closable?: ClosableType;
    props?: DivProps;
    role?: 'alert' | 'status';
}
type StaticFn = (args: ArgsProps) => void;
export interface NotificationInstance {
    success: StaticFn;
    error: StaticFn;
    info: StaticFn;
    warning: StaticFn;
    open: StaticFn;
    destroy(key?: React.Key): void;
}
export interface GlobalConfigProps {
    top?: number;
    bottom?: number;
    duration?: number;
    showProgress?: boolean;
    pauseOnHover?: boolean;
    prefixCls?: string;
    getContainer?: () => HTMLElement | ShadowRoot;
    placement?: NotificationPlacement;
    closeIcon?: React.ReactNode;
    closable?: ClosableType;
    rtl?: boolean;
    maxCount?: number;
    props?: DivProps;
}
export interface NotificationConfig {
    top?: number;
    bottom?: number;
    prefixCls?: string;
    getContainer?: () => HTMLElement | ShadowRoot;
    placement?: NotificationPlacement;
    maxCount?: number;
    rtl?: boolean;
    stack?: boolean | {
        threshold?: number;
    };
    duration?: number;
    showProgress?: boolean;
    pauseOnHover?: boolean;
}
export {};
