import { Result, Button } from "antd";
import { Navigate, useLocation } from "react-router-dom";
import { useAuthStore } from "../store/authStore";
import { can } from "../utils/permissions";

interface Props {
  permission: string;
  children: React.ReactNode;
}

const PermissionRoute = ({ permission, children }: Props) => {
  const user = useAuthStore((s) => s.user);
  const permissions = useAuthStore((s) => s.permissions);
  const location = useLocation();

  if (!user) {
    return <Navigate to="/login" replace state={{ from: location.pathname }} />;
  }
  if (!can(permissions, permission)) {
    return (
      <Result
        status="403"
        title="403"
        subTitle="You do not have permission to access this page."
        extra={
          <Button type="primary" href="/app/home">
            Go Home
          </Button>
        }
      />
    );
  }
  return <>{children}</>;
};

export default PermissionRoute;

