import { useEffect, useState } from "react";
import { Navigate } from "react-router-dom";
import { Spin } from "antd";
import { useAuthStore } from "../store/authStore";
import api from "../api/client";

interface Props {
  children: React.ReactNode;
}

const ProtectedRoute = ({ children }: Props) => {
  const { isAuthenticated, setUser, setPermissions } = useAuthStore();
  const [checking, setChecking] = useState(true);

  useEffect(() => {
    const fetchMe = async () => {
      try {
        const response = await api.get("/auth/me");
        setUser(response.data.data);
        const access = await api.get("/access/me");
        setPermissions(access.data.data.permissions || {});
      } catch {
        setUser(undefined);
        setPermissions({});
      } finally {
        setChecking(false);
      }
    };

    fetchMe();
  }, [setUser, setPermissions]);

  if (checking) {
    return (
      <div style={{ minHeight: "100vh", display: "grid", placeItems: "center" }}>
        <Spin size="large" />
      </div>
    );
  }
  if (!isAuthenticated) {
    return <Navigate to="/login" replace />;
  }
  return <>{children}</>;
};

export default ProtectedRoute;
