import { Result, Button } from "antd";
import { Navigate, useLocation } from "react-router-dom";
import { useAuthStore } from "../store/authStore";
import { can } from "../utils/permissions";

type Role = "administrator" | "editor" | "member";

interface Props {
  roles: Role[];
  children: React.ReactNode;
}

const RoleRoute = ({ roles, children }: Props) => {
  const user = useAuthStore((s) => s.user);
  const permissions = useAuthStore((s) => s.permissions);
  const location = useLocation();

  if (!user) {
    return <Navigate to="/login" replace state={{ from: location.pathname }} />;
  }
  if (roles.includes(user.access_level as Role) || can(permissions, "*")) {
    return <>{children}</>;
  }
  if (!roles.includes(user.access_level as Role)) {
    return (
      <Result
        status="403"
        title="403"
        subTitle="You do not have permission to access this page."
        extra={
          <Button type="primary" href="/app/home">
            Go Home
          </Button>
        }
      />
    );
  }
  return <>{children}</>;
};

export default RoleRoute;
