import { Card, Upload, Button } from "antd";
import { UploadOutlined, DownloadOutlined } from "@ant-design/icons";
import api from "../../api/client";

const ExcelAdminPage = () => {
  const downloadTemplate = async () => {
    const response = await api.get("/admin/download-template", { responseType: "blob" });
    const url = window.URL.createObjectURL(new Blob([response.data]));
    const link = document.createElement("a");
    link.href = url;
    link.setAttribute("download", "savings_plan_import_template.xlsx");
    document.body.appendChild(link);
    link.click();
    link.remove();
  };

  return (
    <Card className="panel" title="Excel Import/Export">
      <div style={{ display: "flex", gap: 16, marginBottom: 16 }}>
        <Button icon={<DownloadOutlined />} onClick={downloadTemplate}>
          Download Template
        </Button>
      </div>
      <Upload
        name="file"
        action={`${import.meta.env.VITE_API_BASE_URL || "http://localhost:5000/api/v1"}/admin/import-excel`}
        withCredentials
      >
        <Button icon={<UploadOutlined />}>Upload Excel</Button>
      </Upload>
    </Card>
  );
};

export default ExcelAdminPage;
