import { create } from "zustand";

export interface UserProfile {
  id: number;
  username: string;
  email: string;
  full_name: string;
  access_level: "administrator" | "editor" | "member";
  account_status?: string;
}

export type Permissions = Record<string, boolean>;

interface AuthState {
  user?: UserProfile;
  setUser: (user?: UserProfile) => void;
  isAuthenticated: boolean;
  permissions: Permissions;
  setPermissions: (permissions: Permissions) => void;
}

export const useAuthStore = create<AuthState>((set) => ({
  user: undefined,
  isAuthenticated: false,
  permissions: {},
  setUser: (user) => set({ user, isAuthenticated: Boolean(user) }),
  setPermissions: (permissions) => set({ permissions: permissions || {} })
}));
