type ColumnDef<T> = {
  title: string;
  dataIndex?: keyof T | string;
  render?: (value: any, record: T) => string | number;
};

const escapeCell = (value: any) => {
  const text = String(value ?? "");
  const escaped = text.replace(/"/g, '""');
  return `"${escaped}"`;
};

export const downloadCsv = <T extends Record<string, any>>(
  filename: string,
  rows: T[],
  columns: ColumnDef<T>[]
) => {
  const headers = columns.map((c) => escapeCell(c.title)).join(",");
  const lines = rows.map((row) => {
    return columns
      .map((c) => {
        const raw = c.dataIndex ? row[c.dataIndex as string] : "";
        const value = c.render ? c.render(raw, row) : raw;
        return escapeCell(value);
      })
      .join(",");
  });
  const csv = [headers, ...lines].join("\r\n");

  const blob = new Blob([csv], { type: "text/csv;charset=utf-8;" });
  const url = URL.createObjectURL(blob);
  const link = document.createElement("a");
  link.href = url;
  link.download = filename;
  document.body.appendChild(link);
  link.click();
  link.remove();
  URL.revokeObjectURL(url);
};
